
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});
	$('#js-member-form').validate({
		rules: {
			name: {
				required: true
			},
			phone: {
				required: true
			},
			valid_from: {
				required: true
			},
			valid_to: {
				required: true
			},
			type: {
				required: true
			},
			profile_image: {
				required: false,
				accept: 'image/jpeg, image/png, image/gif',
			}
		},
		messages: {
			name: "Please enter name",
			phone: "Please enter your phone number.",
			type: "Please select membership type",
			valid_from: "Please select a date",
			valid_to: "Please select a date",
			profile_image: {
				accept: 'Please select a valid image file (JPEG, PNG, GIF)',
			}
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});
